/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.trellis;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.hecco.bountifulfares.BountifulFares;
import net.hecco.bountifulfares.datagen.BFLangProvider;
import net.hecco.bountifulfares.datagen.custom.BFTemplateModels;
import net.hecco.bountifulfares.trellis.BFTrellises;
import net.hecco.bountifulfares.trellis.trellis_parts.DecorativeVine;
import net.hecco.bountifulfares.trellis.trellis_parts.TrellisVariant;
import net.hecco.bountifulfares.trellis.trellis_parts.VineCrop;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7923;

public class TrellisUtil
extends FabricTagProvider.BlockTagProvider {
    public static List<TrellisVariant> TrellisVariants = new ArrayList<TrellisVariant>();
    public static List<VineCrop> VineCrops = new ArrayList<VineCrop>(List.of(BFTrellises.PASSION_FRUIT, BFTrellises.ELDERBERRY, BFTrellises.LAPISBERRY, BFTrellises.GLOW_BERRY));
    public static List<DecorativeVine> DecorativeVines = new ArrayList<DecorativeVine>(List.of(BFTrellises.ROSE, BFTrellises.LILAC, BFTrellises.PEONY, BFTrellises.SUNFLOWER, BFTrellises.VINE, BFTrellises.WEEPING, BFTrellises.TWISTING));

    public TrellisUtil(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    public static void registerTrellisParts() {
        if (BountifulFares.isModLoaded("natures_spirit") || BountifulFares.isDatagen()) {
            DecorativeVines.add(BFTrellises.NS_LAVENDER);
            DecorativeVines.add(BFTrellises.NS_BLEEDING_HEART);
            DecorativeVines.add(BFTrellises.NS_BLUE_BULB);
            DecorativeVines.add(BFTrellises.NS_CARNATION);
            DecorativeVines.add(BFTrellises.NS_GARDENIA);
            DecorativeVines.add(BFTrellises.NS_MARIGOLD);
            DecorativeVines.add(BFTrellises.NS_FOXGLOVE);
        }
        if (BountifulFares.isModLoaded("spawn") || BountifulFares.isDatagen()) {
            VineCrops.add(BFTrellises.SPAWN_SUNFLOWER);
        }
    }

    public static class_2248 registerBlockNoItem(String id, String name, class_2248 block) {
        return (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960(id, name), (Object)block);
    }

    public static class_2248 registerBlock(String id, String name, class_2248 block) {
        TrellisUtil.registerBlockItem(id, name, block);
        return (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960(id, name), (Object)block);
    }

    private static class_1792 registerBlockItem(String id, String name, class_2248 block) {
        return (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(id, name), (Object)new class_1747(block, (class_1792.class_1793)new FabricItemSettings()));
    }

    public static class_2248 getTrellisFromVariant(TrellisVariant variant) {
        return BFTrellises.TRELLISES.get(variant.getBlockName());
    }

    public static class_2248 getCropTrellisFromVariant(TrellisVariant variant, VineCrop crop) {
        return BFTrellises.CROP_TRELLISES.get(crop.getName() + variant.getBlockName());
    }

    public static class_2248 getDecorTrellisFromVariant(TrellisVariant variant, DecorativeVine vine) {
        return BFTrellises.DECORATIVE_TRELLISES.get(vine.getName() + variant.getBlockName());
    }

    public static void registerTrellisModels(class_4910 blockStateModelGenerator, TrellisVariant variant) {
        BFTemplateModels.registerTrellis(blockStateModelGenerator, variant);
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.PASSION_FRUIT), variant.getBlockName(), BFTrellises.PASSION_FRUIT.getName() + "_trellis_vines", BFTrellises.PASSION_FRUIT.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.ELDERBERRY), variant.getBlockName(), BFTrellises.ELDERBERRY.getName() + "_trellis_vines", BFTrellises.ELDERBERRY.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.LAPISBERRY), variant.getBlockName(), BFTrellises.LAPISBERRY.getName() + "_trellis_vines", BFTrellises.LAPISBERRY.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.GLOW_BERRY), variant.getBlockName(), BFTrellises.GLOW_BERRY.getName() + "_trellis_vines", BFTrellises.GLOW_BERRY.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.ROSE), variant.getBlockName(), BFTrellises.ROSE.getName() + "_trellis_vines", BFTrellises.ROSE.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.LILAC), variant.getBlockName(), BFTrellises.LILAC.getName() + "_trellis_vines", BFTrellises.LILAC.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.PEONY), variant.getBlockName(), BFTrellises.PEONY.getName() + "_trellis_vines", BFTrellises.PEONY.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.SUNFLOWER), variant.getBlockName(), BFTrellises.SUNFLOWER.getName() + "_trellis_vines", BFTrellises.SUNFLOWER.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.VINE), variant.getBlockName(), BFTrellises.VINE.getName() + "_trellis_vines", BFTrellises.VINE.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.WEEPING), variant.getBlockName(), BFTrellises.WEEPING.getName() + "_trellis_vines", BFTrellises.WEEPING.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerUpsideDownDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.TWISTING), variant.getBlockName(), BFTrellises.TWISTING.getName() + "_trellis_vines", BFTrellises.TWISTING.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_LAVENDER), variant.getBlockName(), BFTrellises.NS_LAVENDER.getName() + "_trellis_vines", BFTrellises.NS_LAVENDER.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_BLEEDING_HEART), variant.getBlockName(), BFTrellises.NS_BLEEDING_HEART.getName() + "_trellis_vines", BFTrellises.NS_BLEEDING_HEART.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_BLUE_BULB), variant.getBlockName(), BFTrellises.NS_BLUE_BULB.getName() + "_trellis_vines", BFTrellises.NS_BLUE_BULB.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_CARNATION), variant.getBlockName(), BFTrellises.NS_CARNATION.getName() + "_trellis_vines", BFTrellises.NS_CARNATION.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_GARDENIA), variant.getBlockName(), BFTrellises.NS_GARDENIA.getName() + "_trellis_vines", BFTrellises.NS_GARDENIA.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_MARIGOLD), variant.getBlockName(), BFTrellises.NS_MARIGOLD.getName() + "_trellis_vines", BFTrellises.NS_MARIGOLD.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_FOXGLOVE), variant.getBlockName(), BFTrellises.NS_FOXGLOVE.getName() + "_trellis_vines", BFTrellises.NS_FOXGLOVE.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.SPAWN_SUNFLOWER), variant.getBlockName(), BFTrellises.SPAWN_SUNFLOWER.getName() + "_trellis_vines", BFTrellises.SPAWN_SUNFLOWER.getName() + "_trellis_foliage", variant.getModId());
    }

    public static void registerTrellisTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, TrellisVariant trellis) {
        String temp = BFLangProvider.capitalizeString(class_7923.field_41178.method_10221((Object)TrellisUtil.getTrellisFromVariant(trellis).method_8389()).method_12832().replace("_", " "));
        translationBuilder.add(TrellisUtil.getTrellisFromVariant(trellis), temp);
        for (VineCrop crop : VineCrops) {
            translationBuilder.add(TrellisUtil.getCropTrellisFromVariant(trellis, crop), temp);
        }
        for (DecorativeVine vine : DecorativeVines) {
            translationBuilder.add(TrellisUtil.getDecorTrellisFromVariant(trellis, vine), temp);
        }
    }

    public static void registerTrellisTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, TrellisVariant trellis, String display) {
        translationBuilder.add(TrellisUtil.getTrellisFromVariant(trellis), display);
        for (VineCrop crop : VineCrops) {
            translationBuilder.add(TrellisUtil.getCropTrellisFromVariant(trellis, crop), display);
        }
        for (DecorativeVine vine : DecorativeVines) {
            translationBuilder.add(TrellisUtil.getDecorTrellisFromVariant(trellis, vine), display);
        }
    }

    public static void registerTrellisRecipe(Consumer<class_2444> exporter, TrellisVariant trellis) {
        if (trellis.getCraftingItem() != null) {
            class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)TrellisUtil.getTrellisFromVariant(trellis)).method_10439("# #").method_10439(" P ").method_10439("# #").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8600).method_10434(Character.valueOf('P'), (class_1935)trellis.getCraftingItem()).method_10429("has_stick", (class_184)class_2446.method_10426((class_1935)class_1802.field_8600)).method_10429("has_planks", (class_184)class_2446.method_10426((class_1935)trellis.getCraftingItem())).method_10435("trellis").method_10431(exporter);
        }
    }

    protected void method_10514(class_7225.class_7874 arg) {
    }
}

